<?php

namespace App\Cache\Contracts;

interface Cacheable
{
    public function key(): string;

    public function ttl(): ?int;

    public function forever(): bool;

    public function resolve(): mixed;

    public function tags(): array;

    /**
     * Get cached data (or resolve and cache if not yet cached).
     */
    public function get(): mixed;

    /**
     * Force update the cache with fresh data.
     */
    public function refresh(): mixed;

    /**
     * Clear cache completely.
     */
    public function clear(): bool;
}
