<?php

namespace App\Data\Woo;

use App\Data\BaseData;
use Illuminate\Support\Carbon;

class CustomerData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?Carbon $dateCreated,
        public readonly ?Carbon $dateCreatedGmt,
        public readonly ?Carbon $dateModified,
        public readonly ?Carbon $dateModifiedGmt,

        public readonly ?string $email,       // mandatory on create
        public readonly ?string $firstName,
        public readonly ?string $lastName,
        public readonly ?string $role,
        public readonly ?string $username,

        public readonly ?OrderAddressData $billing,
        public readonly ?OrderAddressData $shipping,

        public readonly ?bool $isPayingCustomer,
        public readonly ?string $avatarUrl,

        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'               => 'int',
            'dateCreated'      => 'datetime',
            'dateCreatedGmt'   => 'datetime',
            'dateModified'     => 'datetime',
            'dateModifiedGmt'  => 'datetime',

            'email'            => 'string',
            'firstName'        => 'string',
            'lastName'         => 'string',
            'role'             => 'string',
            'username'         => 'string',
            'password'         => 'string',

            'billing'          => 'object:' . OrderAddressData::class,
            'shipping'         => 'object:' . OrderAddressData::class,

            'isPayingCustomer' => 'bool',
            'avatarUrl'        => 'string',

            'metaData'         => 'collection:' . MetaDataData::class,
        ];
    }

    protected static function rules(): array
    {
        return [
            'email'   => ['nullable', 'email'],
            'role'    => ['nullable', 'string'],
            'username' => ['nullable', 'string'],
        ];
    }


}
