<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class FeeLineData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $name,
        public readonly ?string $taxClass,
        public readonly ?string $taxStatus, // 'taxable' or 'none'
        public readonly ?bool $taxable,     // sometimes present
        public readonly ?string $total,
        public readonly ?string $totalTax,
        /** @var \Illuminate\Support\Collection<TaxItemData>|null */
        public readonly mixed $taxes,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'        => 'int',
            'name'      => 'string',
            'taxClass'  => 'string',
            'taxStatus' => 'string',
            'taxable'   => 'bool',
            'total'     => 'string',
            'totalTax'  => 'string',
            'taxes'     => 'collection:' . TaxItemData::class,
            'metaData'  => 'collection:' . MetaDataData::class,
        ];
    }
}
