<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class LineItemData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $name,
        public readonly ?int $productId,
        public readonly ?int $variationId,
        public readonly ?int $quantity,
        public readonly ?string $taxClass,
        public readonly ?string $subtotal,
        public readonly ?string $subtotalTax,
        public readonly ?string $total,
        public readonly ?string $totalTax,
        /** @var \Illuminate\Support\Collection<TaxItemData>|null */
        public readonly mixed $taxes,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
        public readonly ?string $sku,
        public readonly ?string $price, // present in some payloads
    ) {}

    protected static function casts(): array
    {
        return [
            'id'          => 'int',
            'name'        => 'string',
            'productId'   => 'int',
            'variationId' => 'int',
            'quantity'    => 'int',
            'taxClass'    => 'string',
            'subtotal'    => 'string',
            'subtotalTax' => 'string',
            'total'       => 'string',
            'totalTax'    => 'string',
            'taxes'       => 'collection:' . TaxItemData::class,
            'metaData'    => 'collection:' . MetaDataData::class,
            'sku'         => 'string',
            'price'       => 'string',
        ];
    }
}
