<?php

namespace App\Data\Woo;

use App\Data\BaseData;
use Illuminate\Support\Carbon;

class OrderData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?int $parentId,
        public readonly ?string $number,
        public readonly ?string $orderKey,
        public readonly ?string $createdVia,
        public readonly ?string $version,
        public readonly ?string $status,
        public readonly ?string $currency,

        public readonly ?Carbon $dateCreated,
        public readonly ?Carbon $dateCreatedGmt,
        public readonly ?Carbon $dateModified,
        public readonly ?Carbon $dateModifiedGmt,

        public readonly ?string $discountTotal,
        public readonly ?string $discountTax,
        public readonly ?string $shippingTotal,
        public readonly ?string $shippingTax,
        public readonly ?string $cartTax,
        public readonly ?string $total,
        public readonly ?string $totalTax,
        public readonly ?bool $pricesIncludeTax,

        public readonly ?int $customerId,
        public readonly ?string $customerIpAddress,
        public readonly ?string $customerUserAgent,
        public readonly ?string $customerNote,

        public readonly ?OrderAddressData $billing,
        public readonly ?OrderAddressData $shipping,

        public readonly ?string $paymentMethod,
        public readonly ?string $paymentMethodTitle,
        public readonly ?string $transactionId,

        public readonly ?Carbon $datePaid,
        public readonly ?Carbon $datePaidGmt,
        public readonly ?Carbon $dateCompleted,
        public readonly ?Carbon $dateCompletedGmt,

        public readonly ?string $cartHash,

        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,

        /** @var \Illuminate\Support\Collection<LineItemData>|null */
        public readonly mixed $lineItems,

        /** @var \Illuminate\Support\Collection<TaxLineData>|null */
        public readonly mixed $taxLines,

        /** @var \Illuminate\Support\Collection<ShippingLineData>|null */
        public readonly mixed $shippingLines,

        /** @var \Illuminate\Support\Collection<FeeLineData>|null */
        public readonly mixed $feeLines,

        /** @var \Illuminate\Support\Collection<CouponLineData>|null */
        public readonly mixed $couponLines,

        /** @var \Illuminate\Support\Collection<RefundData>|null */
        public readonly mixed $refunds,

        public readonly ?bool $setPaid, // only used when creating/updating
    ) {}

    protected static function casts(): array
    {
        return [
            'id'                 => 'int',
            'parentId'           => 'int',
            'number'             => 'string',
            'orderKey'           => 'string',
            'createdVia'         => 'string',
            'version'            => 'string',
            'status'             => 'string',
            'currency'           => 'string',

            'dateCreated'        => 'datetime',
            'dateCreatedGmt'     => 'datetime',
            'dateModified'       => 'datetime',
            'dateModifiedGmt'    => 'datetime',

            'discountTotal'      => 'string',
            'discountTax'        => 'string',
            'shippingTotal'      => 'string',
            'shippingTax'        => 'string',
            'cartTax'            => 'string',
            'total'              => 'string',
            'totalTax'           => 'string',
            'pricesIncludeTax'   => 'bool',

            'customerId'         => 'int',
            'customerIpAddress'  => 'string',
            'customerUserAgent'  => 'string',
            'customerNote'       => 'string',

            'billing'            => 'object:' . OrderAddressData::class,
            'shipping'           => 'object:' . OrderAddressData::class,

            'paymentMethod'      => 'string',
            'paymentMethodTitle' => 'string',
            'transactionId'      => 'string',

            'datePaid'           => 'datetime',
            'datePaidGmt'        => 'datetime',
            'dateCompleted'      => 'datetime',
            'dateCompletedGmt'   => 'datetime',

            'cartHash'           => 'string',

            'metaData'           => 'collection:' . MetaDataData::class,
            'lineItems'          => 'collection:' . LineItemData::class,
            'taxLines'           => 'collection:' . TaxLineData::class,
            'shippingLines'      => 'collection:' . ShippingLineData::class,
            'feeLines'           => 'collection:' . FeeLineData::class,
            'couponLines'        => 'collection:' . CouponLineData::class,
            'refunds'            => 'collection:' . RefundData::class,

            'setPaid'            => 'bool',
        ];
    }

    protected static function rules(): array
    {
        return [
            'status'   => ['nullable'],
            'currency' => ['nullable', 'string', 'size:3'], // accepts wide ISO set
        ];
    }
}
