<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class ShippingLineData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $methodTitle,
        public readonly ?string $methodId,
        public readonly ?string $total,
        public readonly ?string $totalTax,
        /** @var \Illuminate\Support\Collection<TaxItemData>|null */
        public readonly mixed $taxes,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'         => 'int',
            'methodTitle' => 'string',
            'methodId'   => 'string',
            'total'      => 'string',
            'totalTax'   => 'string',
            'taxes'      => 'collection:' . TaxItemData::class,
            'metaData'   => 'collection:' . MetaDataData::class,
        ];
    }
}
