<?php

namespace App\Enums;

use App\Traits\EnumToArray;

enum OrderReturnStatusEnum: string
{
    use EnumToArray;
    case Requested = 'requested';          // Customer requested a return
    case Approved = 'approved';           // Merchant approved the request
    case Rejected = 'rejected';           // Merchant rejected the request
    case PickedUp = 'picked_up';          // Courier picked up the item
    case Received = 'received';           // Warehouse received the item
    case Inspected = 'inspected';          // QC inspection complete
    case RefundInitiated = 'refund_initiated';   // Refund process has started
    case RefundCompleted = 'refund_completed';   // Refund has been issued
    case Cancelled = 'cancelled';          // Return request cancelled
    case Completed = 'completed';          // Entire return cycle finished
}
