<?php

namespace App\Enums;

use App\Traits\EnumToArray;


enum OrderStatusEnum: string
{
    use EnumToArray;

    case Pending  = "Pending";
    case AwaitingPayment = "Awaiting Payment";
    case AwaitingFulfillment = "Awaiting Fulfillment";
    case AwaitingShipment = "Awaiting Shipment";
    case AwaitingPickup = "Awaiting Pickup";
    case PartiallyShipped = "Partially Shipped";
    case Completed = "Completed";
    case Shipped = "Shipped";
    case Cancelled = "Cancelled";
    case Declined = "Declined";
    case Refunded = "Refunded";
    case Disputed = "Disputed";
    case ManualVerificationRequired = "Manual Verification Required";
    case PartiallyRefunded = "Partially Refunded";
}
