<?php

namespace App\Http\Actions\Admin;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Order;
use App\Models\Category;
use App\Models\Option;
use App\Models\Shop;
use Illuminate\Http\Request;
use Illuminate\View\View;

class MenuBuilderAction
{
    /**
     * Handle the incoming menu builder request.
     */
    public function __invoke(Request $request)
    {

        Option::updateOrCreate(
            attributes: [
                'group' => 'menus',
                'key' => 'primary-menu',
                'value' => 'primary-menu',
            ],
            values: [
                'data' => $request->input('menu'),
            ]
        );

        return back()->sweetalert()->success(__('menu updated successfully'));
    }
}
