<?php

namespace App\Http\Actions;

use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Models\ProductBundle;
use App\Services\Models\CartService;

class OfficeEquipmentProductAddToCartAction
{
    protected CartService $cart;

    public function __construct(CartService $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke(Request $request, $group)
    {
        $group = ProductBundle::findOrFail($group);

        if (!$group) {
            $group->load('products');
        }


        // all
        if ($request->action === 'all') {
            $products = $group->products;
            foreach ($products as $key => $product) {
                $data = [
                    'product_id'   => $product->id,
                    'inventory_id' => $product->inventories->first()->id ?? null,
                    'shop_id'      => $product->shop_id,
                    'quantity'     => $product->pivot->quantity ?? 1, // default quantity
                    'variant'      => [],
                    'price'        => $product->price,
                    'discount'     => $product->discount_price,
                    'coupon'       => null,
                    'data'         => [],
                ];

                $this->cart->add(
                    $data['product_id'],
                    $data['inventory_id'],
                    $data['shop_id'],
                    $data['quantity'],
                    $data['variant'],
                    $data['price'],
                    $data['discount'],
                    $data['coupon'],
                    $data['data']
                );
            }
        }
        // equipment
        if ($request->action === 'equipment') {
            $products = $group->products->groupBy('consumable')->get("0", collect([]));

            if ($products->isEmpty()) {
                return back()->with('error', __('No equipment products found.'));
            }

            foreach ($products as $key => $product) {
                $data = [
                    'product_id'   => $product->id,
                    'inventory_id' => $product->inventories->first()->id ?? null,
                    'shop_id'      => $product->shop_id,
                    'quantity'     => $product->pivot->quantity ?? 1, // default quantity
                    'variant'      => [],
                    'price'        => $product->price,
                    'discount'     => $product->discount_price,
                    'coupon'       => null,
                    'data'         => [],
                ];

                $this->cart->add(
                    $data['product_id'],
                    $data['inventory_id'],
                    $data['shop_id'],
                    $data['quantity'],
                    $data['variant'],
                    $data['price'],
                    $data['discount'],
                    $data['coupon'],
                    $data['data']
                );
            }
        }
        // consumable
        if ($request->action === 'consumable') {
            $products = $group->products->groupBy('consumable')->get("1", collect([]));

            if ($products->isEmpty()) {
                return back()->with('error', __('No consumable products found.'));
            }

            foreach ($products as $key => $product) {
                $data = [
                    'product_id'   => $product->id,
                    'inventory_id' => $product->inventories->first()->id ?? null,
                    'shop_id'      => $product->shop_id,
                    'quantity'     => $product->pivot->quantity ?? 1, // default quantity
                    'variant'      => [],
                    'price'        => $product->price,
                    'discount'     => $product->discount_price,
                    'coupon'       => null,
                    'data'         => [],
                ];

                $this->cart->add(
                    $data['product_id'],
                    $data['inventory_id'],
                    $data['shop_id'],
                    $data['quantity'],
                    $data['variant'],
                    $data['price'],
                    $data['discount'],
                    $data['coupon'],
                    $data['data']
                );
            }
        }



        return redirect()->route('office-equipment.products', $group->id)->with('success', __('Products added to cart successfully.'));
    }
}
