<?php

namespace App\Http\Actions;

use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Services\Models\CartService;
use App\Services\Models\OrderService;
use App\Services\Models\CouponService;
use App\Http\Controllers\PaymentController;

class OrderSubmissionAction
{
    protected CartService $cart;

    public function __construct(CartService $cart)
    {
        $this->cart = $cart;
    }


    public function __invoke(Request $request)
    {

        $cart = $this->cart->getCart();
        $couponDiscount = 0;
        $items = $this->cart->items();
        $total = $this->cart->total();
        $totalPayable = $this->cart->totalPayable();


        $items = $items->map(function ($item) {
            return [
                'item_type'    => get_class($item->product), // or another type if needed
                'item_id'      => $item->product_id,
                'inventory_id' => $item->inventory_id,
                'variant_id'   => $item->variant_id ?? null,
                'variant'      => (isset($item->variant) && empty($item->variant)) ? json_encode($item->variant) : json_encode([]),
                'count'        => $item->quantity,
                'name'         => $item->product->title ?? null,
                'price'        => $item->price,
                'discount'     => $item->discount,
                'coupon'       => $item->coupon,
                'details'      => $item->data,
            ];
        });



        $order = OrderService::createOrder(
            purchaser: auth()->user(),
            purchasable: $cart,
            data: [
                'amount' => $cart->grand_total,
                'address_id' => $cart->address_id,
            ],
            items: $items
        );
        $cart->update(['status' => 'ordered']);

        return redirect()->action([PaymentController::class, 'create'], [
            'tracking_code' => $order->tracking_code,
            'uuid' => $order->uuid,
            'payment_method' => $request->payment_method ?? 'bitpay_test',
        ]);
    }
}
