<?php

namespace App\Http\Actions\Pages;

use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Services\Models\CartService;
use App\Services\Models\CouponService;

class CartCheckoutPageAction
{
    protected CartService $cart;

    public function __construct(CartService $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke(Request $request)
    {
        $couponDiscount = 0;
        $items = $this->cart->items();
        $cart = $this->cart->getCart();
        $totalPayable = $this->cart->totalPayable();



        if ($request->has(key: 'coupon')) {
            $couponDiscount = (new CouponService)->checkCoupon(coupon: $request->coupon, user: auth()->user(), total: $cart->subtotal);
            // dd($couponDiscount);

            if ($couponDiscount->response === false) {
                return redirect()->route('cart.checkout')->with('coupon_error', $couponDiscount->message);
            }

            $this->cart->updateCoupon(coupon: $request->coupon, discount: $couponDiscount->discount_amount);

            $couponDiscount = $couponDiscount->discount_amount;
        }

        return view('pages.cart-checkout', compact('items', 'cart', 'couponDiscount', 'totalPayable'));
    }
}
