<?php

namespace App\Http\Actions\Pages;

use Artemis\Faq\Models\Question;
use Illuminate\Http\Request;
use Illuminate\View\View;

class FaqHomePageAction
{
    public function __invoke(Request $request): View
    {
        $answeredQuestions = Question::with(['answers', 'user'])
            ->whereNotNull('best_answer_id')
            ->latest()
            ->take(5)
            ->get();

        return view('pages.faq.faq-home', compact('answeredQuestions'));
    }
}
