<?php

namespace App\Http\Actions\Pages;

use App\Models\Post;
use Illuminate\View\View;
use Illuminate\Http\Request;
use Artemis\Faq\Models\Question;

class HomePageAction
{
    public function __invoke(Request $request): View
    {
        seo()->setTitle(title: __('Home'));

        $posts = Post::latest()->take(5)->get();

        $answeredQuestions = Question::with(['answers', 'user'])
            ->whereNotNull('best_answer_id')
            ->latest()
            ->take(5)
            ->get();

        return view('pages.home', compact('posts'));
    }
}
