<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\DeliveryDayCapacity;
use Illuminate\Http\Request;

class DeliveryDayCapacityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $deliveryDayCapacities = DeliveryDayCapacity::when($request->date, function ($query, $date) {
            $query->where('date', $date);
        })->get();

        return view('pages.admin.delivery.day-capacity.index', compact('deliveryDayCapacities'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view('pages.admin.delivery.day-capacity.create', ['date' => $request->date]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'date' => 'required|date',
            'delivery_time_id' => 'required',
            'taken' => 'required|integer',
        ]);

        $capacity = DeliveryDayCapacity::create($validated);

        return redirect()->route('admin.delivery.day-capacities.index', ['date' => $capacity->date])->sweetalert()->success(__('Day Capacity added successfully'));
    }

    /**
     * Display the specified resource.
     */
    public function show(DeliveryDayCapacity $delivery_day_capacity)
    {
        return view('pages.admin.delivery.day-capacity.show', compact('delivery_day_capacity'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, DeliveryDayCapacity $delivery_day_capacity)
    {
        return view('pages.admin.delivery.day-capacity.edit', [
            'date' => $request->date,
            'delivery_day_capacity' => $delivery_day_capacity
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryDayCapacity $delivery_day_capacity)
    {
        $validated = $request->validate([
            'date' => 'required|date',
            'delivery_time_id' => 'required',
            'taken' => 'required|integer',
        ]);

        $delivery_day_capacity->update($validated);

        return redirect()->route('admin.delivery.day-capacities.index', ['date' => $delivery_day_capacity->date])->sweetalert()->success(__('Day Capacity updated successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryDayCapacity $delivery_day_capacity)
    {
        $date = $delivery_day_capacity->date;
        try {
            $delivery_day_capacity->delete();
            return redirect()->route('admin.delivery.day-capacities.index', ['date' => $date])->sweetalert()->success(__('Day Capacity Deleted successfully'));
        } catch (\Throwable $th) {
            return redirect()->route('admin.delivery.day-capacities.index', ['date' => $date])->sweetalert()->failure(__('Something went wrong. try again'));
        }
    }
}
