<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\DeliveryTimeReservation;
use Illuminate\Http\Request;

class DeliveryTimeReservationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $deliveryTimeReservations = DeliveryTimeReservation::when($request->date, function ($query, $date) {
            $query->where('date', $date);
        })->get();

        return view('pages.admin.delivery.time-reservation.index', compact('deliveryTimeReservations'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view('pages.admin.delivery.time-reservation.create', ['date' => $request->date]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'date' => 'required|date',
            'delivery_time_id' => 'required',
            'user_id' => 'required',
        ]);

        $reservation = DeliveryTimeReservation::create($validated);

        return redirect()->route('admin.delivery.time-reservations.index', ['date' => $reservation->date])->sweetalert()->success(__('Time Reservation added successfully'));
    }

    /**
     * Display the specified resource.
     */
    public function show(DeliveryTimeReservation $delivery_time_reservation)
    {
        return view('pages.admin.delivery.time-reservation.show', compact('delivery_time_reservation'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, DeliveryTimeReservation $delivery_time_reservation)
    {
        return view('pages.admin.delivery.time-reservation.edit', [
            'date' => $request->date,
            'delivery_time_reservation' => $delivery_time_reservation
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryTimeReservation $delivery_time_reservation)
    {
        $validated = $request->validate([
            'date' => 'required|date',
            'delivery_time_id' => 'required',
            'user_id' => 'required',
        ]);

        $delivery_time_reservation->update($validated);

        return redirect()->route('admin.delivery.time-reservations.index', ['date' => $delivery_time_reservation->date])->sweetalert()->success(__('Time Reservation updated successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryTimeReservation $delivery_time_reservation)
    {
        $date = $delivery_time_reservation->date;
        try {
            $delivery_time_reservation->delete();
            return redirect()->route('admin.delivery.time-reservations.index', ['date' => $date])->sweetalert()->success(__('Time Reservation Deleted successfully'));
        } catch (\Throwable $th) {
            return redirect()->route('admin.delivery.time-reservations.index', ['date' => $date])->sweetalert()->failure(__('Something went wrong. try again'));
        }
    }
}
