<?php

namespace App\Http\Controllers\Admin\Faq;

use Artemis\Faq\Models\Flag;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\SweetAlert;

class FlagController extends Controller
{
    public function index()
    {
        // Fetch all flags from the database
        $flags = Flag::with(['flaggable', 'user'])
            ->orderBy('created_at', 'desc')
            ->get(); // Adjust the pagination as needed

        // Return a view with the flags data
        return view('pages.admin.faq.flags.index', compact('flags'));
    }

    public function destroy(Flag $flag)
    {
        $flag->flaggable->delete();
        $flag->delete();
        return redirect()->route('admin.faq.flags.index')->sweetalert()->success(__('Flag deleted successfully.'));
    }
}
