<?php

namespace App\Http\Controllers\Admin;

use App\Enums\QuoteStatusEnum;
use App\Http\Controllers\Controller;
use App\Models\PreInvoice;
use App\Models\Quote;
use App\Models\Shop;
use Illuminate\Http\Request;

class PreInvoiceQuoteController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(PreInvoice $preInvoice)
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(PreInvoice $preInvoice)
    {
        return view('pages.admin.pre-invoice.quote.create', compact('preInvoice'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, PreInvoice $preInvoice)
    {

        $supplier =  auth()->user()->isAdmin() ? Shop::find($request->supplier_id) : auth()->user()->shop;

        $quote =  $preInvoice->quotes()->updateOrCreate(
            [
                'supplier_id' => $supplier->id,
            ],
            [
                'total' => 0,
                'currency' => 'IRR',
                'status' => QuoteStatusEnum::Sent->value,
            ]
        );

        if (isset($request->items)) {
            foreach ($request->items as $key => $item) {
                $quote->items()->updateOrCreate(
                    [
                        'pre_invoice_item_id' => $key,
                    ],
                    [
                        'price' => $item['price'],
                        'qty' => $item['qty'],
                        'delivery_time' => $item['delivery_time'],
                        'note' => $item['note'],
                    ]
                );
            }
        }

        $quote->getTotalCalculatedAttribute();
        return redirect()->route('admin.pre-invoice.show', $preInvoice->id);
    }

    /**
     * Display the specified resource.
     */
    public function show(PreInvoice $preInvoice, Quote $quote)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PreInvoice $preInvoice, Quote $quote)
    {
        return view('pages.admin.pre-invoice.quote.edit', compact('preInvoice', 'quote'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PreInvoice $preInvoice, Quote $quote)
    {
        $supplier =  auth()->user()->isAdmin() ? Shop::find($request->supplier_id) : auth()->user()->shop;

        $quote =  $preInvoice->quotes()->updateOrCreate(
            [
                'supplier_id' => $supplier->id,
            ],
            [
                'total' => 0,
                'currency' => 'IRR',
                'status' => QuoteStatusEnum::Sent->value,
            ]
        );

        if (isset($request->items)) {
            foreach ($request->items as $key => $item) {
                $quote->items()->updateOrCreate(
                    [
                        'pre_invoice_item_id' => $key,
                    ],
                    [
                        'price' => $item['price'],
                        'qty' => $item['qty'],
                        'delivery_time' => $item['delivery_time'],
                        'note' => $item['note'],
                    ]
                );
            }
        }
        $quote->getTotalCalculatedAttribute();
        return redirect()->route('admin.pre-invoice.show', $preInvoice->id);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PreInvoice $preInvoice, Quote $quote)
    {
        //
    }
}
