<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ProductBundle;

class ProductBundleController extends Controller
{
    public function index()
    {
        $groups = ProductBundle::all();
        return view('pages.admin.product-bundle.index', compact('groups'));
    }

    public function create()
    {
        return view('pages.admin.product-bundle.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        $validated['created_by'] = auth()->id();

        ProductBundle::create($validated);

        return redirect()->route('admin.product-bundle.index')->with('success', __('Office Equipment Group created successfully.'));
    }

    public function show(ProductBundle $product_bundle)
    {
        return view('pages.admin.product-bundle.show', compact('product_bundle'));
    }

    public function edit(ProductBundle $product_bundle)
    {
        return view('pages.admin.product-bundle.edit', compact('product_bundle'));
    }

    public function update(Request $request, ProductBundle $product_bundle)
    {

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        $validated['created_by'] = auth()->id();

        $product_bundle->update($validated);


        return redirect()->route('admin.product-bundle.index')->with('success', 'Office Equipment Group updated successfully.');
    }

    public function destroy(ProductBundle $product_bundle)
    {
        $product_bundle->delete();
        return redirect()->route('admin.product-bundle.index')->with('success', 'Office Equipment Group deleted successfully.');
    }
}
