<?php

namespace App\Http\Controllers\Admin\WooCommerce;

use App\Data\Woo\OrderData;
use Illuminate\Http\Request;

class WooOrderController extends WooBaseController
{
    public function list(Request $request)
    {
        $since   = $request->string('since')->toString();  // e.g. ISO8601 or null
        $page    = (int) $request->input('page', 1);
        $perPage = (int) $request->input('per_page', 20);
        $status  = $request->input('status');              // publish|draft|...

        $key = $this->cacheKey('order', compact('since', 'page', 'perPage', 'status'));


        if ($request->boolean('refresh')) {
            $this->forget($key);
        }

        $orders = $this->remember($key, $this->defaultTtl(), function () use ($since, $page, $perPage, $status) {
            $apiResult = $this->wooClient->ordersSince();
            return OrderData::collection($apiResult);
        });
        return view('pages.admin.woo-commerce.order.list', compact('orders'));
    }
}
