<?php

namespace App\Http\Controllers\Admin\WooCommerce;

use Illuminate\Http\Request;
use App\Data\Woo\ProductData;

class WooProductController extends WooBaseController
{
    public function list(Request $request)
    {
        $since   = $request->string('since')->toString();  // e.g. ISO8601 or null
        $page    = (int) $request->input('page', 1);
        $perPage = (int) $request->input('per_page', 20);
        $status  = $request->input('status');              // publish|draft|...

        $key = $this->cacheKey('products', compact('since', 'page', 'perPage', 'status'));

        if ($request->boolean('refresh')) {
            $this->forget($key);
        }

        $products = $this->remember($key, $this->defaultTtl(), function () use ($since, $page, $perPage, $status) {
            // $apiResult = $this->wooClient->productsSince(
            //     since: $since,
            //     page: $page,
            //     perPage: $perPage,
            //     status: $status
            // );
            $apiResult = $this->wooClient->productsSince();
            return ProductData::collection($apiResult);
        });

        return view('pages.admin.woo-commerce.product.list', compact('products'));
    }
}
