<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class RegisterController extends Controller
{
    public function __invoke(Request $request)
    {
        $request->validate(
            [
                'name' => 'required|max:255',
                'username' => 'nullable|unique:users|max:255',
                'email' => 'required|unique:users|email|max:255',
                'phone' => 'nullable|unique:users|max:255',
                'password' => 'required|confirmed',
            ]
        );

        $user = User::create([
            'name' => $request->name,
            'username' => $request->username,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
        ]);

        $user->assignRole('client');

        auth()->attempt($request->only('email', 'password'));

        return redirect()->route('admin.dashboard');
    }

    public function index()
    {
        return view('auth.register');
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'name' => 'required|max:255',
                'username' => 'nullable|unique:users|max:255',
                'email' => 'required|unique:users|email|max:255',
                'phone' => 'nullable|unique:users|max:255',
                'password' => 'required|confirmed',
            ]
        );

        $user = User::create([
            'name' => $request->name,
            'username' => $request->username,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        $user->assignRole('client');

        Auth::login($user);

        return redirect()->route('client.dashboard');
    }
}
