<?php

namespace App\Listeners;

use App\Events\UserVisitedProduct;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class AddProductToUserHistory
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(UserVisitedProduct $event): void
    {
        if (!auth()->check()) return;

        // Check if the user has already viewed the product
        if (!$event->product->viewers()->where('user_id', auth()->user()->id)->exists()) {
            // If not, attach the user with the current timestamp
            $event->product->viewers()->attach(auth()->user()->id, ['updated_at' => now()]);
        } //
    }
}
