<?php

namespace App\Livewire\Admin\Components;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use App\Services\Models\FileService;
use Illuminate\Support\Facades\Storage;

class FilePickerModal extends Component
{
    use WithFileUploads;

    public $show = false;
    public $uploadedFile;
    public $files = [];
    public $targetModel;
    public string $model = '';

    #[On('open-file-picker')]
    public function open(string $model)
    {
        $this->model = $model;
        $this->show = true;
    }

    public function refreshFiles()
    {
        $this->files = collect(Storage::disk('public')->files('uploads'))
            ->filter(fn($file) => str($file)->match('/\.(jpg|jpeg|png|webp|gif)$/i'))
            ->map(fn($file) => asset('storage/' . $file))
            ->values()
            ->toArray();
    }

    public function uploadFile()
    {
        $this->validate([
            'uploadedFile' => 'image|max:10240' // 10MB
        ]);

        $uploaded = (new FileService)->upload($this->uploadedFile);

        $url = asset('uploads/' . $uploaded['path']);

        $this->dispatch('file-uploaded', url: $url, model: $this->model);
        $this->show = false;
    }

    public function selectFile($url)
    {
        $this->dispatch('file-uploaded', url: $url, model: $this->model);
        $this->show = false;
    }

    public function render()
    {
        return view('livewire.admin.components.file-picker-modal');
    }
}
