<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Illuminate\Support\Facades\Storage;

class FileManager extends Component
{
    public string $disk = 'public';
    public string $path = '/';

    public array $directories = [];
    public array $files = [];

    public function mount()
    {
        $this->loadContent();
    }

    public function loadContent()
    {
        $this->directories = Storage::disk($this->disk)->directories($this->path);
        $this->files = Storage::disk($this->disk)->files($this->path);
    }

    public function goToDirectory($directory)
    {
        $this->path = $directory;
        $this->loadContent();
    }

    public function goBack()
    {
        $parts = explode('/', trim($this->path, '/'));
        array_pop($parts);
        $this->path = count($parts) ? implode('/', $parts) : '/';
        $this->loadContent();
    }
    public function render()
    {
        return view('livewire.admin.file-manager');
    }
}
