<?php

namespace App\Livewire\Auth;

use Livewire\Component;

class LoginForm extends Component
{
    public $step = 'identifier';

    protected $listeners = [
        'showIdentifierStep' => 'showIdentifierStep',
        'showRegisterStep' => 'showRegisterStep',
        'showPasswordStep' => 'showPasswordStep',
        'showVerificationStep' => 'showVerificationStep',
    ];

    public function showRegisterStep()
    {
        $this->step = 'register';
    }

    public function showIdentifierStep()
    {
        $this->step = 'identifier';
    }

    public function showPasswordStep()
    {
        $this->step = 'password';
    }

    public function showVerificationStep()
    {
        $this->step = 'verification';
    }

    public function render()
    {
        return view('livewire.auth.login-form');
    }
}
