<?php

namespace App\Livewire\Auth;

use App\Exceptions\OtpException;
use App\Models\User;
use App\Services\OtpService;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Validate;
use Livewire\Component;

class LoginIdentifier extends Component
{
    #[Validate('required')]
    public $identifier;

    public function handel()
    {
        $this->validate();

        if (filter_var($this->identifier, FILTER_VALIDATE_EMAIL)) {
            // Store identifier in session and move to password input
            Session::put('login_identifier', $this->identifier);

            if (User::where('email', $this->identifier)->exists()) {
                $this->dispatch('showPasswordStep');
            } else {
                $this->dispatch('showRegisterStep');
            }
        } elseif (preg_match('/^\+?\d{10,15}$/', $this->identifier)) {
            try {
                $result = OtpService::sendOtp($this->identifier);
            } catch (OtpException $exception) {
                $this->addError('identifier', $exception->getMessage());
            }
            Session::put('login_identifier', $this->identifier);
            $this->dispatch('showVerificationStep');
        } else {
            $this->addError('identifier', 'Invalid email or phone number format.');
        }
    }

    public function render()
    {
        return view('livewire.auth.login-identifier');
    }
}
