<?php

namespace App\Livewire\Blesser\Comment;

use Livewire\Component;
use App\Enums\CommentStatusEnum;
use Livewire\Attributes\Validate;

class CommentForm extends Component
{

    public $product;
    #[Validate('required')]
    public $recommendation;
    #[Validate('required')]
    public $message;
    #[Validate('required')]
    public $rate;


    public function saveComment()
    {
        $this->validate();

        $this->product->comments()->create([
            'user_id' => auth()->id(),
            'name' => auth()->user()->name,
            'content' => $this->message,
            'rate' => $this->rate,
            'seller_satisfactory' => $this->recommendation,
            'status' => CommentStatusEnum::Pending,
        ]);

        session()->flash('success', __('The operation was successful'));

        $this->resetExcept('product');
    }

    public function render()
    {
        return view('livewire.blesser.comment.comment-form');
    }
}
