<?php

namespace App\Livewire\Blesser;

use App\Models\Product;
use App\Models\Category;
use Livewire\Component;

class DesktopSearchComponent extends Component
{
    public string $query = '';
    public $products = [];
    public $categories = [];
    public $productInCategories = [];
    public bool $showDropdown = false;

    public function updatedQuery($value): void
    {
        $value = trim((string) $value);

        if ($value === '') {
            $this->resetResults();
            return;
        }

        // keep it lightweight; expand as needed
        $this->products = Product::query()
            ->where('title', 'like', "%{$value}%")
            ->select('id', 'price', 'title', 'slug', 'brand_img') // limit columns for speed
            ->latest('id')
            ->take(6)
            ->get();

        $this->categories = Category::query()
            ->where('name', 'like', "%{$value}%")
            ->select('id', 'name')
            ->latest('id')
            ->take(6)
            ->get();

        $this->productInCategories = Category::query()
            ->whereHas('products', function ($query) use ($value) {
                $query->where('title', 'like', "%{$value}%");
            })
            ->select('id', 'name')
            ->latest('id')
            ->limit(6)
            ->get();

        $this->showDropdown = true;

        // dd($this);
    }

    public function hideDropdown(): void
    {
        $this->showDropdown = false;
    }

    public function resetResults(): void
    {
        $this->products = [];
        $this->categories = [];
        $this->showDropdown = false;
        $this->productInCategories = [];
    }

    public function render()
    {
        return view('livewire.blesser.desktop-search-component');
    }
}
