<?php

namespace App\Livewire\Resources;

use App\Models\Order;
use Livewire\Component;
use App\Services\Models\OrderService;

class UserOrders extends Component
{
    public $orders;
    public $orderDetails = null;
    public $images;

    private $orderService;

    public function __construct()
    {
        $this->orderService = new OrderService;
    }

    public function mount()
    {
        $this->orders = auth()->user()->orders()->with('items.item')->latest()->get();
    }
    public function showOrderDetails($id)
    {
        $order = Order::find($id);
        $order->load(['user', 'items', 'deliveries', 'metas', 'payments', 'createdBy', 'orderedBy', 'orderable', 'address', 'deliveryTime', 'coupon']);
        $this->orderDetails = $order;
    }
    public function clearOrderDetails()
    {
        $this->orderDetails = null;
    }
    
    public function render()
    {
        return view('livewire.resources.user-orders');
    }
}
