<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Address extends Model
{
    protected $fillable = [
        'user_id',
        'address',
        'province',
        'city',
        'neighborhood',
        'plaque',
        'unit',
        'zip_code',
        'latitude',
        'longitude',
        'owner_is_receiver',
        'receiver_name',
        'receiver_phone',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
