<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Brand extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'logo',
        'category_id',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(related: Category::class);
    }

    public function scopeInCategory(Builder $query, int $categoryId): Builder
    {
        return $query->where('category_id', $categoryId);
    }
    public function scopeInCategories(Builder $query, array $categoriesId): Builder
    {
        return $query->whereIn('category_id', $categoriesId);
    }

    public static function generateSlug(string $title): string
    {
        $baseSlug = Str::slug($title);
        $slugCount = static::where('slug', 'like', "$baseSlug%")->count();

        return $slugCount === 0 ? $baseSlug : $baseSlug . '-' . ($slugCount + 1);
    }
}
