<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    protected $fillable = [
        'user_id',
        'address_id',
        'session_id',
        'name',
        'status',
        'currency',
        'subtotal',
        'discount_total',
        'tax_total',
        'shipping_total',
        'grand_total',
        'coupon',
    ];

    protected $with = ['items'];

    public function items()
    {
        return $this->hasMany(CartItem::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function address()
    {
        return $this->belongsTo(Address::class);
    }


    public function recalculateTotals()
    {
        $this->items->each(fn($item) => $item->recalculateTotals());

        $subtotal = $this->items->sum('total');
        $discount = $this->discount_total ?? 0;
        $tax = $subtotal * 0; //  9% tax
        $shipping = 0; //  9% tax
        $grand = $subtotal - $discount + $tax;

        $this->update([
            'subtotal' => $subtotal,
            'discount_total' => $discount,
            'tax_total' => $tax,
            'shipping_total' => $shipping,
            'grand_total' => $grand,
        ]);
    }
}
