<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'description',
        'type',
        'amount',
        'allow_free_shipment',
        'expire_date',
        'max_discount',
        'minimum_spend',
        'maximum_spend',
        'individual_use_only',
        'exclude_sale_items',
        'products',
        'exclude_products',
        'product_categories',
        'exclude_categories',
        'allowed_emails',
        'usage_limit',
        'product_limit',
        'usage_limit_per_user',
    ];

    protected $casts = [
        'allow_free_shipment' => 'boolean',
        'expire_date' => 'datetime',
        'individual_use_only' => 'boolean',
        'exclude_sale_items' => 'boolean',
        'products' => 'array',
        'exclude_products' => 'array',
        'product_categories' => 'array',
        'exclude_categories' => 'array',
        'allowed_emails' => 'array',
        'amount' => 'float',
        'max_discount' => 'float',
        'minimum_spend' => 'float',
        'maximum_spend' => 'float',
    ];

    public const TYPES = ['Percentage Discount', 'Fixed Cart Discount', 'Fixed Product Discount'];
}
