<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DeliveryTime extends Model
{
    protected $fillable = [
        'id',
        'day',
        'from',
        'until',
        'capacity',
    ];

    /**
     * The part below is for this model relationships
     */
    public function exceptions()
    {
        return $this->hasMany(DeliveryTimeException::class);
    }

    public function dayCapacities()
    {
        return $this->hasMany(DeliveryDayCapacity::class);
    }

    public function reservations()
    {
        return $this->hasMany(DeliveryTimeReservation::class);
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class);
    }

    /**
     * The above is for this model relationships
     */
}
