<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeliveryTimeException extends Model
{
    protected $fillable = [
        'delivery_time_id',
        'date',
    ];

    /**
     * The part below is for this model relationships
     */
    public function deliveryTime(): BelongsTo
    {
        return $this->belongsTo(DeliveryTime::class);
    }
    /**
     * The above is for this model relationships
     */
}
