<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Module extends Model
{
    protected $fillable = [
        'label',
        'name',
        'is_active',
        'is_paid',
        'is_free',
        'is_permanent',
        'activated_at',
        'expire_at',
        'requirements',
        'options',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_paid' => 'boolean',
        'is_free' => 'boolean',
        'is_permanent' => 'boolean',
        'activated_at' => 'datetime',
        'expire_at' => 'datetime',
    ];

    public function isActive(): bool
    {
        // for now is simple but later we should add more complex logic like checking expiration date etc.
        return $this->is_active;
    }



    /**
     * Helper to easily activate or deactivate the module.
     */
    public function activate(?Carbon $expireAt = null): void
    {
        $this->update([
            'is_active' => true,
            'activated_at' => now(),
            'expire_at' => $expireAt,
        ]);
    }

    public function deactivate(): void
    {
        $this->update(['is_active' => false]);
    }
}
