<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderMeta extends Model
{
    protected $fillable = [
        'order_id',
        'group',
        'key',
        'value',
        'data',
    ];

    /**
     * The part below is for this model relationships
     */
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }
    /**
     * The above is for this model relationships
     */
}
