<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Page extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'status',
        'content',
        'excerpt',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'template',
        'featured_image',
        'parent_id',
        'position',
        'is_published',
        'published_at',
        'author_id',
        'css',
        'js',
        'components_json',
        'styles_json',
        'assets_json',
        'published_html',
        'gjs_source',
    ];

    protected $casts = [
        'published_at' => 'datetime',
        'is_published' => 'boolean',
    ];

    public function author(): BelongsTo
    {
        return $this->belongsTo(related: User::class, foreignKey: 'author_id');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(related: Page::class, foreignKey: 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(related: Page::class, foreignKey: 'parent_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(related: PageItem::class)->orderBy(column: 'order');
    }

    public function versions(): HasMany
    {
        return $this->hasMany(related: PageVersion::class);
    }
}
