<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PageVersion extends Model
{
    protected $fillable = [
        'page_id',
        'created_by',
        'content',
        'css',
        'components_json',
        'styles_json'
    ];
    public function page(): BelongsTo
    {
        return $this->belongsTo(related: Page::class);
    }
}
