<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Traits\HasTrackingCode;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payment extends Model
{
    use HasFactory, HasTrackingCode;

    protected $fillable = [
        'uuid',
        'user_id',
        'payable_type',
        'payable_id',
        'gateway',
        'transaction_id',
        'amount',
        'tracking_code',
        'description',
        'status',
        'data',
    ];

    public static function uuid($uuid): Payment
    {
        return self::with(['user', 'payable'])->where('uuid', $uuid)->firstOrFail();
    }

    /**
     * The part below is for this model relationships
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function steps(): HasMany
    {
        return $this->hasMany(PaymentStep::class);
    }

    public function payable(): MorphTo
    {
        return $this->morphTo();
    }

    /**
     * The above is for this model relationships
     */
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $model->uuid = Str::uuid()->toString();
            $model->tracking_code = self::createTrackingCode();
        });
    }
}
