<?php

namespace App\Models;

use App\Traits\HasFile;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Post extends Model
{
    use HasFile;
    protected $fillable = [
        'user_id',
        'author',
        'title',
        'content',
        'short_desc',
        'comment_status',
        'slug',
        'price',
        'password',
        'type',
        'name',
        'layout',
        'status',
        'img',
        'video'
    ];

    protected $with = ['user'];
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
