<?php

namespace App\Models;

use App\Traits\HasFile;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PreInvoiceItem extends Model
{
    use HasFactory, HasFile;

    protected $fillable = [
        'pre_invoice_id',
        'product_id',
        'name',
        'sku',
        'qty',
        'unit',
        'estimated_price',
        'description',
        'external_url',
        'options',
    ];

    public function preInvoice()
    {
        return $this->belongsTo(PreInvoice::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function quoteItems()
    {
        return $this->hasMany(QuoteItem::class, 'pre_invoice_item_id');
    }

    public function getSubtotalAttribute()
    {
        return $this->estimated_price ? $this->estimated_price * $this->qty : 0;
    }
}
