<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductBundle extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'created_by',
    ];

    /**
     * Get the user who created the group.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the products associated with the group.
     */
    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_bundle_items')
                    ->withPivot('quantity')
                    ->withTimestamps();
    }
}
