<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductMeta extends Model
{
    protected $fillable = [
        'product_id',
        'key',
        'value',
        'data',

    ];

    /**
     * The part below is for this model relationships
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
    /**
     * The above is for this model relationships
     */
}
