<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Quote extends Model
{
    use HasFactory;

    protected $fillable = [
        'pre_invoice_id',
        'supplier_id',
        'total',
        'currency',
        'status',
        'terms',
        'notes',
        'options',
    ];


    public function preInvoice()
    {
        return $this->belongsTo(PreInvoice::class);
    }

    public function supplier()
    {
        return $this->belongsTo(Shop::class, 'supplier_id');
    }

    public function items()
    {
        return $this->hasMany(QuoteItem::class);
    }

    public function getTotalCalculatedAttribute()
    {
        return $this->items->sum(fn($i) => $i->price * $i->qty);
    }
    public function recalculateTotal()
    {
        $this->total = $this->totalCalculated;
        $this->save();

        return $this;
    }
}
