<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class QuoteItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'quote_id',
        'pre_invoice_item_id',
        'price',
        'qty',
        'delivery_time',
        'note',
        'options',
    ];

    public function quote()
    {
        return $this->belongsTo(Quote::class);
    }

    public function preInvoiceItem()
    {
        return $this->belongsTo(PreInvoiceItem::class, 'pre_invoice_item_id');
    }

    public function getSubtotalAttribute()
    {
        return $this->price * $this->qty;
    }
}
