<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'warehouse_id',
        'product_inventory_id',
        'product_inventory_variant_id',
        'type',
        'qty',
        'reference_type',
        'reference_id',
        'meta',
        'moved_at',
        'user_id'
    ];

    protected $casts = [
        'meta' => 'array',
        'moved_at' => 'datetime',
    ];

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
}
