<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WalletSettlement extends Model
{
    protected $fillable = [
        'user_id',
        'wallet_id',
        'amount',
        'status',
        'description',
    ];

    /**
     * The part below is for this model relationships
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }
    /**
     * The above is for this model relationships
     */
}
