<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

class WarehouseInventory extends Model
{
    protected $fillable = [
        'warehouse_id',
        'product_inventory_id',
        'product_inventory_variant_id',
        'sku',
        'qty_on_hand',
        'qty_reserved',
        'min_qty',
        'max_qty'
    ];

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function productInventory()
    {
        return $this->belongsTo(ProductInventory::class);
    }

    public function variant()
    {
        return $this->belongsTo(ProductInventoryVariant::class, 'product_inventory_variant_id');
    }
}
